#Include file for GURPS printing.
#
# Macro for extracting item name/info, level and cost.
#
$$define fixnotes %replaceString(replaceString(@notes,'/[\n\r]+/',' '), '/ +$/','')%
#
$$macro extract(name, level, cost)
{{@if incategory('Super Power')
	@assign _n=split(@item, "	", '$(name)', '_junk', '$(cost)', '$(level)')
@else
	@assign _n=split(@item, "	", '$(name)', '$(cost)', '$(level)')
@endif
@if $(cost)='--'
	@assign $(cost)=''
@endif
@if $(level)=' '
	@assign $(level)=''
@endif}}
#
$$macro setIndent(indented, uli, utabs, ili, itabs)
{{@if ($(indented)) != _indented
@if $(indented)
@leftindent $(ili)
@tabs $(itabs)
@else
@leftindent $(uli)
@tabs $(utabs)
@endif
@endif
@assign _indented=($(indented))}}
#
$$macro advIndent(indented)
{{$$setIndent($(indented), 0.29in, 1 .21in 0 .29in,  0.37in, 1 .21in 0 .39in)}}
#
$$macro skIndent(indented)
{{@if ($(indented)) != _indented
@if $(indented)
@leftindent .2in
@firstIndent .1in
@else
@leftindent .1in
@firstIndent 0in
@endif
@endif
@assign _indented=($(indented))}}
#
$$macro dispList(list){{
@var _cost, _level, _name
@if(@`$(List)`)
@assign _indented=0
@foreach($(list))
$$advIndent(@indent!=0)
$$extract(_name, _level, _cost)
@if strindex(_cost, '*')
@_cost=replaceString(_cost, '*', '')
@_name=concat("*", _name)
@endif
@if @sublist
@bold
@italic
	?_cost?%_cost%??	%_name%\
@else
@plain
	?_cost?%_cost%?--?	\
	@if _level<>''
		@assign _paren=strindex(_name, " (")
		@if _paren
			@output %substr(_name, 1, _paren-1)% %_level% %substr(_name, _paren+1, strlen(_name)-_paren)%\
		@else
			@output %_name% %_level%\
		@endif
	@else
		@output %_name%\
	@endif
@endif
@if @notes and ConfigParam("PrintOptions")
; $(fixnotes)\
@endif
@if @options and ConfigParam("PrintOptions")
@options()
@if ConfigParam("SkipZeroOptions")
@if (@optType = "Multiplier" and @optvalue = 1) or @optvalue=0
@else
; %@option%\
@endif
@else
; %@option%\
@endif
@endoptions
@endif

@endfor
$$advIndent(0)
@endif}}
$$macro searchList(listName, optName, dispName, dispText, separator)
{{@foreach($(listName))
@if optPresent('$(optName)')
$(separator)$(dispName): $(dispText)\
@endif
@endfor}}
#
$$macro dispOptInfo(optName, dispName, dispText, separator){{
$$searchList(Skills, $(optName), $(dispName), $(dispText), $(separator))\
$$searchList(Advantages, $(optName), $(dispName), $(dispText), $(separator))\
$$searchList(Powers, $(optName), $(dispName), $(dispText), $(separator))\
$$searchList(Equipment, $(optName), $(dispName), $(dispText), $(separator))}}
#
# Display the text in the Skills box.
#
$$macro dispSkills(x){{
@assign _indented=0
@foreach(skill)
$$skIndent(@indent!=0)
@if inCategory("Note")
%@name%
@elseif @sublist
@bold
@italic
%@name%	?@cost=0?--?%@cost%?
@plain
@else
@assign _n=split(@item, "	", "_name", "_diff", "_cost", "_lev")
@if _lev = ""
$$dskill(_name)	?_diff=0?--?%_diff%?	%_cost%
@else
$$dskill(_name)	?_cost=0?--?%_cost%?	%_lev%
@endif
@if ConfigParam("PrintSkillOptions") and (@options or @notes)
	\
	@options(, )
%@option%\
	@endoptions
@if @options and @notes
; \
@endif
@if @notes
$(fixnotes)\
@endif

@endif
@endif
@endfor
$$skIndent(0)
@if !@BlankCharsheet and @spells and ConfigParam("PrintSpellsWithSkills")
@if @Skills > 0

@endif
@keepnext
@bold
Spells
@plain
@foreach(spell)
$$skIndent(@indent!=0)
@if inCategory("Note")
%@name%
@elseif inCategory("College Skill")
@assign _n=split(@item, "	", "_name", "_lev")
%_name%	--	%_lev%
@elseif @sublist
@bold
@italic
%@name%	?@cost=0?--?%@cost%?
@plain
@else
@assign _n=split(@item, "	", "_name", "_coll", "_cost", "_lev")
%_name%	?_cost=0?--?%_cost%?	%_lev%
@endif
@if ConfigParam("PrintSpellOptions") and (@options or @notes)
	\
	@options(, )
%@option%\
	@endoptions
@if @options and @notes
; \
@endif
@if @notes
$(fixnotes)\
@endif

@endif
@endfor
$$skIndent(0)
@endif}}
#
# Display the text in the advantages and disadvantages box.
#
$$macro dispAdvDisadv(dummy){{
$$dispList(Additional Attributes)
$$dispList(Advantages)
$$dispList(Powers)
@if @disadvantages
$$dispList(Disadvantages)
@endif
@if @quirks
@foreach(quirk)
	%@cost%	%@name%
@endfor
@endif}}
#
# Display damage types
#
$$macro dispDmg(separator){{
Thrust: %t_thrdmg%
$(separator)Swing: %t_swdmg%
$(separator)Punch: %punch%
$(separator)Kick: %kick%
$$dispOptInfo(Display Damage, %@name%, %@Damage%, $(separator))
}}
$$macro encTable(dummy){{
@if @BlankCharsheet
None (0) = 2  ST
Light (1) = 4  ST
Med (2) = 6  ST
Hvy (3) = 12  ST
X-hvy (4) = 20  ST
@else
@var wm
None (%encmv(1)%) = %useMetric?format('\%1d',encmult(1)/2.2):encmult(1)%  ST
Light (%encmv(2)%) = %useMetric?format('\%1d',encmult(2)/2.2):encmult(2)%  ST
Med (%encmv(3)%) = %useMetric?format('\%1d',encmult(3)/2.2):encmult(3)%  ST
Hvy (%encmv(4)%) = %useMetric?format('\%1d',encmult(4)/2.2):encmult(4)%  ST
X-hvy (%encmv(5)%) = %useMetric?format('\%1d',encmult(5)/2.2):encmult(5)%  ST
@endif}}
#
# Display various kinds of speeds.
#
$$macro speeds(x){{
?speed!=runningSpeed? / Running: %runningSpeed%??\
?flightCapable? / Flying: %flyingSpeed%??\
?amphibious? / Swimming: %swimmingSpeed%??}}
$$macro showSpeed(n, show) {{
@assign _i=1
@foreach(Advantages)
@if optPresent("Speed")
@if _i=$(n)
$$if(show != '@optValue')%$(show)%$$else%optValue('Speed')%$$endif
@endif
@assign _i=_i+1
@endif
@endfor
}}
#
# collegeSkills -- print college skill levels if indicated.
#
$$macro collegeSkills(junk)
{{
@if ConfigParam("PrintCollegeSkills")
@array _colleges[0]
@assign _n = removeAllElements(_colleges);
@array _collList[0]
@assign _n = removeAllElements(_collList);
#
@foreach(Spell)
	@if !@sublist and @level > 0
		@assign _val = 0
		@if @level >= 20
			@assign _val = 2
		@elseif @level >= 16
			@assign _val = 1.5
		@elseif @level >= 12
			@assign _val = 1
		@endif
		@assign _n = split(@category, ";", _collList);
		@assign _i = 1
		@while _i <= sizeof(_collList)
			@if strindex(_collList[_i], "*") != 1
				@assign _n = putAssoc(_colleges, _collList[_i], getAssoc(_colleges, _collList[_i]) + _val)
#%@name%:%_collList[_i]%=%_val%, _n = %_n%, total=%getAssoc(_colleges, _collList[_i])%
			@endif
			@assign _i = _i+1
		@endwhile
	@endif
@endfor
@if sizeof(_colleges) > 0

@keepnext
@bold
College Skills	Level
@plain
	@assign _n=removeAllElements(_collList)
	@assign _i = 1
	@while _i <= sizeof(_colleges)
		@assign _n=addElement(_collList, format('%s	%s', _Colleges[_i], min(iq+magery, 20, integer(_colleges[_i+1]))))
		@assign _i = _i + 2
	@endwhile
	@assign _n=sortElements(_collList, 1)
	@assign _i = 1
	@while _i <= sizeof(_collList)
%_collList[_i]%
		@assign _i = _i + 1
	@endwhile
@endif
@endif}}
$$macro semi(arg)
{{
@if $$ifnull(arg)__semineeded$$else$(arg)$$endif
; \
@endif
@assign $$ifnull(arg)__semineeded$$else$(arg)$$endif = 1
}}
$$macro dispAdvPowers(list,header,unheader,endPar,needTab,sameline,needHyphen)
{{@if @`$(list)`

@if !listiteminfo('$(list)', 1, '@sublist@')
$(header)
$(list)$$ifnull(sameline)$(endPar)$$endif
$(unheader)
@endif
$$ifdef(needTab)	$$endif\
@assign __needSep=0
@foreach($(list))
@if @sublist
@if __needSep
.$(endPar)

@endif
$(header)
%@name%$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
# Look for any options to print.
@assign __options=0
@options()
@if ConfigParam("SkipZeroOptions")
@if (@optType = "Multiplier" and @optvalue = 1) or @optvalue=0
@else
@assign __options=__options+1
@endif
@else
@assign __options=__options+1
@endif
@endoptions
@if (@notes or __options) and ConfigParam("PrintOptions")
@assign __semineeded=0
@if __options
Base Cost: %@basecost%\
@assign __semineeded=1
@endif
@options()
@if ConfigParam("SkipZeroOptions")
@if (@optType = "Multiplier" and @optvalue = 1) or @optvalue=0
@else
$$semi()%@option%\
@endif
@else
$$semi()%@option%\
@endif
@endoptions
@if __options
; Final Cost: %@cost%\
@endif
@if @notes
$$semi()$(fixnotes)\
@endif
.$(endPar)
$$ifdef(needTab)	$$endif\
@endif
@assign __needSep=0
@elseif inCategory("Note")
@if @name != '' and @name != '--'
$$semi(__needSep)%@name%\
@endif
@else
$$extract(_name, _level, _cost)
$$semi(__needSep)\
@if _level<>''
@assign _paren=strindex(_name, " (")
@if _paren
%substr(_name, 1, _paren-1)% %_level% %substr(_name, _paren+1, strlen(_name)-_paren)%\
@else
%_name% %_level%\
@endif
@else
%_name%\
@endif
?_cost <>''? [%_cost%]??\
# Look for any options to print.
@assign __options=0
@options()
@if ConfigParam("SkipZeroOptions")
@if (@optType = "Multiplier" and @optvalue = 1) or @optvalue=0
@else
@assign __options=__options+1
@endif
@else
@assign __options=__options+1
@endif
@endoptions
@if (@notes or __options) and ConfigParam("PrintOptions")
 (\
@assign __semineeded=0
@options()
@if ConfigParam("SkipZeroOptions")
@if (@optType = "Multiplier" and @optvalue = 1) or @optvalue=0
@else
$$semi()%@option%\
@endif
@else
$$semi()%@option%\
@endif
@endoptions
@if @notes
$$semi()$(fixnotes)\
@endif
)\
@endif
@endif
@endfor
.$(endPar)
@endif}}
$$macro dskill(name)
{{\
@assign _tlindx=strindex($(name), "/TL")
@assign _parenindx=strindex($(name), " (")
@if _tlindx > 0 and _parenindx > 0 and _tlindx > _parenindx
%substr($(name), 1, _parenindx-1)%%substr($(name), _tlindx, strlen($(name))-_tlindx+1)%\
%substr($(name), _parenindx, _tlindx-_parenindx)%\
@else
%$(name)%\
@endif
}}
$$macro dispSkillList(header, unheader, endPar, needTab,sameline)
{{@if @`Skills`

$$ifdef(needTab)@keepnext$$endif
$(header)
Skills$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __semiNeeded=0
@foreach(Skills)
@if @sublist
@if __semiNeeded
.$(endPar)

@endif
$$ifdef(needTab)@keepnext$$endif
$(header)
%@name%$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __semiNeeded=0
@elseif inCategory("Note")
@if @name != '' and @name != '--'
$$semi()%@name%\
@endif
@else
@assign _n=split(@item, "	", "_name", "_diff", "_cost", "_lev")
$$semi()$$dskill(_name)-%_lev%\
@if _cost
?_cost='--'?? [%_cost%]?\
@else
 [default]\
@endif
@if ConfigParam("PrintSkillOptions") and (@options or @notes)
 (\
@options(, )
%@option%\
@endoptions
@if @options and @notes
; \
@endif
@if @notes
$(fixnotes)\
@endif
)\
@endif
@endif
@endfor
.$(endPar)
@endif}}
#
# Macro for displaying equipment in filters.
#
$$macro dispEquip(header, unheader, endPar, needTab, sameline)
{{@if @`Equipment`

$$ifdef(needTab)@keepnext$$endif
$(header)
Equipment$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __needSep=0
@foreach(Equipment)
@if @sublist
@if __needSep
.$(endPar)

@endif
$(header)
%@name%?@cost? (%dw(@cost)%)??$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __needSep=0
@elseif inCategory("Note")
@if @name != '' and @name != '--'
$$semi(__needSep)%@name%\
@endif
@else
@assign __semiNeeded=0
@assign _n=split(@item, "	", "_name", "_price", "_weight")
$$semi(__needSep)\
@if ConfigParam('PrintOptions') and (@cost or @Price or @notes or @options)
@if strindex(_name, "/\) *$/") > 0
%replaceString(_name, "/\\) *$/", "")%\
@assign __semiNeeded=1
@else
%_name% (\
@endif
@if _weight and _weight <> '--'
$$semi()%_weight% \
@if useMetric
kg\
@else
?@cost<>1?lbs?lb?.\
@endif
@endif
@if _price and _price <> '--'
$$semi()%_price%\
@endif
@if (@notes or @options) and ConfigParam("PrintOptions")
@options()
$$semi()%@option%\
@endoptions
@if @notes
$$semi()$(fixnotes)\
@endif
@endif
)\
@else
%_name%\
@endif
@endif
@endfor
.$(endPar)
@endif}}
#
# Common macro for displaying spells in filters.
#
$$macro dispSpells(header, unheader, endPar, needTab, sameline)
{{@if @`Spells`

$(header)
Spells$$ifnull(sameline)$(endPar)$$endif
$$ifdef(needTab)	$$endif\
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __semiNeeded=0
@foreach(Spells)
@if @sublist
@if __semiNeeded
.$(endPar)

@endif
$(header)
%@name%$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@assign __semiNeeded=0
@elseif inCategory("Note")
@if @name != '' and @name != '--'
$$semi()%@name%\
@endif
@elseif inCategory("College Skill")
$$semi()%@name%-%optValue('Level')%\
@else
$$semi()%@name%-%@level%?@cost>1? [%@cost%]??\
@if ConfigParam("PrintSpellOptions") and (@options or @notes)
 (\
@options(, )
%@option%\
@endoptions
@if @options and @notes
; \
@endif
@if @notes
$(fixnotes)\
@endif
)\
@endif
@endif
@endfor
.$(endPar)
@endif}}
$$macro dispQuirks(header, unheader, endPar, needTab, sameline)
{{@if @`Quirks`

$$ifdef(needTab)@keepnext$$endif
$(header)
Quirks$$ifnull(sameline)$(endPar)$$endif
$(unheader)
$$ifdef(needTab)	$$endif\
@foreach(Quirks,; )
%@name%\
@endfor
. [%quirks%]$(endPar)
@endif}}
$$macro dispOptNotes()
{{@if ConfigParam('PrintOptions') and (@options or @notes)
	\
@if @options
@options(; )
%@option%\
@endoptions
@endif
@if @notes
@if @options
; \
@endif
$(fixnotes)\
@endif

@endif}}
$$macro dispPrtEquip(dummy)
{{@foreach(Equipment)
@if @sublist
@bold
@italic
%@name%		%@cost%
@plain
@elseif inCategory("Note")
%@name%
@else
@assign _n=split(@item, "	", "_name", "_price", "_weight")
%_name%	?_Price?%_Price%??	?_weight=0?--?%_weight%?
$$dispOptNotes()
@endif
@endfor}}
$$macro showBlock(j){{%u_block%?u_block!=t_block?/%t_block%??}}
$$macro showParry(j){{%u_parry%?u_parry!=t_parry?/%t_parry%??}}
$$macro showDodge(j){{%u_dodge%?u_dodge!=dodge?/%dodge%??}}
#
$$macro NonWindowsTranslation(type)
{{
@if ConfigParam("NonWindowsTrans")
@trans  x
$$if(type="RTF")
@trans  {\\super 1}/{\\sub 4}
@trans  {\\super 1}/{\\sub 2}
@trans  {\\super 3}/{\\sub 4}
$$else
$$if(type="HTML")
@trans  <sup>1</sup>/<sub>4</sub>
@trans  <sup>1</sup>/<sub>2</sub>
@trans  <sup>3</sup>/<sub>4</sub>
$$else
@trans  1/4
@trans  1/2
@trans  3/4
$$endif
$$endif
@endif}}
#
$$macro printHandWeap(dummy)
{{
@var dmgArr[0]
@var reachArr[0]
@var notesArr[0]
@var ndmg,nread,nnotes,n,i
@foreach(Equipment)
@if incategory("Hand Weapon")
@if @`Damage`
@ndmg=split(@`Damage`, "/, */", dmgArr)
@nread=split(@`Reach`, "/; */", reachArr)
@if @notes
@nnotes=split(@notes, "/; */", notesArr)
@else
@n = removeAllElements(notesArr);
@endif
@else
@n=removeAllElements(reachArr)
@n=removeAllElements(dmgArr)
@n=removeAllElements(notesArr)
@n=addElement(reachArr, "")
@n=addElement(dmgArr, "")
@n=addElement(notesArr, "")
@endif
%@name%	%dmgArr[1]%	\
%reachArr[1]%	%@ST%	?sizeof(notesArr)>0?%notesArr[1]%??	\
%@Parry%	%@Skill%
@i=2
@while i <= sizeof(dmgArr)
@if i <= sizeof(dmgArr)
	%dmgArr[i]%	\
?i<=sizeof(reachArr)?%reachArr[i]%??		\
?@notes and i<=sizeof(notesArr)?%notesArr[i]%??
@endif
@assign i=i+1
@endwhile
@endif
@endfor
}}
